/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.util;

import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.taskcontroller.TaskControllerListener;
import com.ibm.hwmca.fw.servlet.taskcontroller.TaskControllerQueue;
import com.ibm.hwmca.fw.servlet.util.HMCCustomScope;
import com.ibm.hwmca.fw.servlet.util.HMCSessionLifeListener;
import com.ibm.hwmca.fw.servlet.util.HMCSessionListener;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;

public class HMCSession {
    private static final String TRACE_MASKT = "XTIFSEST";
    private static final String TRACE_MASKF = "XTIFSESF";
    private static final String HMCSESSION_ATTRIBUTE_IN_HTTP_SESSION = "util.hmcsession";
    private static final String HMCSESSION_NAME_ATTRIBUTE_IN_HTTP_SESSION = "hmcsession";
    private static final String REAP_TIME_ATTRIBUTE_IN_PORTAL = "util.hmcsession.reapTime";
    private static final int ZOMBIE_WAIT_TIME = 90000;
    private static long sessionIdSequence;
    private static List allSessions;
    private static List allDisconnectedSessions;
    private static List sessionLifeListeners;
    private Map contextAttributes = new HashMap();
    private Map sessionAttributes = new HashMap();
    private HttpSession httpSession;
    private String sessionId;
    private HMCCustomScope wclScopeObject;
    private Date creationTime;
    private Date connectionTime;
    private Date disconnectionTime;
    private Date lossOfConnectivityTime;
    private ClientUserContext userContext;
    private Listener listener;
    private Map taskIdToPanelPortals = new HashMap();
    private List endedTasks = new ArrayList(5);
    private List sessionListeners = new ArrayList(5);

    private HMCSession(HttpSession httpSession) {
        this.sessionId = HMCSession.assignName();
        this.creationTime = new Date();
        Trace.trace(TRACE_MASKT, "Creating new HMCSession with id " + this.sessionId);
        this.wclScopeObject = new HMCCustomScope(this.sessionId);
        this.setContextAttribute(this.sessionId, this.wclScopeObject);
        HMCSession.addSession(this);
        this.connectToWebSession(httpSession);
        this.listener = new Listener();
        TaskControllerQueue.getTaskControllerQueue(this).addTaskControllerListener(this.listener);
    }

    public static synchronized HMCSession getHMCSession(HttpSession httpSession) {
        HMCSession hmcSession = (HMCSession)httpSession.getAttribute(HMCSESSION_ATTRIBUTE_IN_HTTP_SESSION);
        if (hmcSession == null) {
            hmcSession = new HMCSession(httpSession);
        }
        return hmcSession;
    }

    private static synchronized String assignName() {
        return "util.hmcsession." + Long.toString(++sessionIdSequence);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getDisplayableSessionId() {
        return this.sessionId.substring(this.sessionId.lastIndexOf(46) + 1);
    }

    public synchronized void connectToWebSession(HttpSession httpSession) throws IllegalStateException {
        HMCSession hmcSession = (HMCSession)httpSession.getAttribute(HMCSESSION_ATTRIBUTE_IN_HTTP_SESSION);
        if (hmcSession != null) {
            throw new IllegalStateException("The HTTP session is already connected to an HMC session");
        }
        if (this.httpSession != null) {
            throw new IllegalStateException("The HMC session is already connected to an HTTP session");
        }
        Trace.trace(TRACE_MASKT, "Connecting HMCSession with id " + this.sessionId + " to HTTP session with id " + httpSession.getId());
        this.httpSession = httpSession;
        httpSession.setAttribute(HMCSESSION_ATTRIBUTE_IN_HTTP_SESSION, (Object)this);
        httpSession.setAttribute(HMCSESSION_NAME_ATTRIBUTE_IN_HTTP_SESSION, (Object)this.sessionId);
        this.connectionTime = new Date();
        this.disconnectionTime = null;
        this.copyAttributesToServletContext();
        this.fireSessionConnectedEvent();
        HMCSession.removeDisconnectedSession(this);
    }

    private synchronized void copyAttributesToServletContext() {
        ServletContext context = this.httpSession.getServletContext();
        Iterator iterator = this.contextAttributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            context.setAttribute((String)entry.getKey(), entry.getValue());
        }
    }

    public synchronized void disconnectFromWebSession() throws IllegalStateException {
        if (this.httpSession == null) {
            throw new IllegalStateException("The HMC session is already disconnected");
        }
        Trace.trace(TRACE_MASKT, "Disconnecting HMCSession with id " + this.sessionId + " from HTTP session with id " + this.httpSession.getId());
        this.httpSession.removeAttribute(HMCSESSION_ATTRIBUTE_IN_HTTP_SESSION);
        this.httpSession.removeAttribute(HMCSESSION_NAME_ATTRIBUTE_IN_HTTP_SESSION);
        this.httpSession = null;
        this.disconnectionTime = new Date();
        this.connectionTime = null;
        this.fireSessionDisconnectedEvent();
        HMCSession.addDisconnectedSession(this);
    }

    public boolean isDisconnected() {
        return this.httpSession == null;
    }

    private static synchronized void addDisconnectedSession(HMCSession hmcSession) {
        if (allDisconnectedSessions == null) {
            allDisconnectedSessions = new ArrayList();
        }
        allDisconnectedSessions.add(hmcSession);
    }

    private static synchronized void removeDisconnectedSession(HMCSession hmcSession) {
        if (allDisconnectedSessions == null) {
            return;
        }
        allDisconnectedSessions.remove(hmcSession);
    }

    private static synchronized void addSession(HMCSession hmcSession) {
        allSessions.add(hmcSession);
        HMCSession.fireSessionCreatedEvent(hmcSession);
    }

    private static synchronized void removeSession(HMCSession hmcSession) {
        allSessions.remove(hmcSession);
        HMCSession.fireSessionRemovedEvent(hmcSession);
    }

    public ClientUserContext getUserContext() {
        return this.userContext;
    }

    public void setUserContext(ClientUserContext userContext) {
        this.userContext = userContext;
    }

    public static synchronized Collection getAllSessions() {
        return new ArrayList(allSessions);
    }

    public static synchronized Collection getDisconnectedSessions(String user) {
        if (allDisconnectedSessions == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<HMCSession> result = new ArrayList<HMCSession>();
        Iterator iterator = allDisconnectedSessions.iterator();
        while (iterator.hasNext()) {
            HMCSession hmcSession = (HMCSession)iterator.next();
            ClientUserContext uContext = hmcSession.getUserContext();
            if (uContext == null || !uContext.getUserName().equals(user)) continue;
            result.add(hmcSession);
        }
        return result;
    }

    public synchronized void addHMCSessionListener(HMCSessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public synchronized void removeHMCSessionListener(HMCSessionListener listener) {
        this.sessionListeners.remove(listener);
    }

    public static synchronized void addHMCSessionLifeListener(HMCSessionLifeListener listener) {
        if (sessionLifeListeners == null) {
            sessionLifeListeners = new ArrayList(3);
        }
        sessionLifeListeners.add(listener);
    }

    public static synchronized void removeHMCSessionLifeListener(HMCSessionLifeListener listener) {
        if (sessionLifeListeners == null) {
            return;
        }
        sessionLifeListeners.remove(listener);
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getConnectionTime() {
        return this.connectionTime;
    }

    public Date getDisconnectionTime() {
        return this.disconnectionTime;
    }

    public synchronized ServletContext getServletContext() {
        return this.httpSession != null ? this.httpSession.getServletContext() : null;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public HMCCustomScope getHMCCustomScope() {
        return this.wclScopeObject;
    }

    public synchronized PanelModelTaskPortal getPanelModelTaskPortal(String taskId) {
        return (PanelModelTaskPortal)this.taskIdToPanelPortals.get(taskId);
    }

    public synchronized void addTask(PanelModelTaskPortal portal) {
        String taskId = portal.getTaskId();
        if (this.isKnownTask(taskId)) {
            throw new IllegalStateException("Task id " + taskId + " is already running.");
        }
        Trace.trace(TRACE_MASKT, "Adding task with id " + taskId + " to HMCSession with id " + this.sessionId);
        this.taskIdToPanelPortals.put(taskId, portal);
        this.fireTaskStartedEvent(portal);
    }

    public synchronized void removeTask(String taskId) {
        if (!this.isKnownTask(taskId)) {
            throw new IllegalStateException("Task id " + taskId + " is not running.");
        }
        Trace.trace(TRACE_MASKT, "Removing task with id " + taskId + " from HMCSession with id " + this.sessionId);
        PanelModelTaskPortal portal = (PanelModelTaskPortal)this.taskIdToPanelPortals.remove(taskId);
        if (portal != null && this.endedTasks.contains(portal)) {
            this.endedTasks.remove(portal);
            this.notifyAll();
        }
    }

    public synchronized boolean isKnownTask(String taskId) {
        return this.taskIdToPanelPortals.containsKey(taskId);
    }

    public synchronized Collection getKnownTasks() {
        return new ArrayList(this.taskIdToPanelPortals.values());
    }

    public synchronized Collection getRunningTasks() {
        Collection tasks = this.getKnownTasks();
        Iterator iterator = tasks.iterator();
        while (iterator.hasNext()) {
            PanelModelTaskPortal portal = (PanelModelTaskPortal)iterator.next();
            if (!portal.isTaskEnded()) continue;
            iterator.remove();
        }
        return tasks;
    }

    public synchronized int getKnownTaskCount() {
        return this.taskIdToPanelPortals.size();
    }

    public synchronized PanelModelTaskPortal getTaskForWindowName(String name) {
        PanelModelTaskPortal portal;
        Iterator iterator = this.getKnownTasks().iterator();
        while (iterator.hasNext()) {
            portal = (PanelModelTaskPortal)iterator.next();
            if (portal.isTaskEnded() || !portal.getWindowName().equals(name)) continue;
            return portal;
        }
        iterator = this.getKnownTasks().iterator();
        while (iterator.hasNext()) {
            portal = (PanelModelTaskPortal)iterator.next();
            if (!portal.getWindowName().equals(name)) continue;
            return portal;
        }
        return null;
    }

    public synchronized void taskEnded(PanelModelTaskPortal task) {
        Trace.trace(TRACE_MASKT, "Task with id " + task.getTaskId() + " has ended in HMCSession with id " + this.sessionId + ".  Leaving as zombie for " + 90000 + " milliseconds");
        task.setAttribute(REAP_TIME_ATTRIBUTE_IN_PORTAL, new Date(System.currentTimeMillis() + 90000L));
        this.endedTasks.add(task);
        if (this.endedTasks.size() == 1) {
            Thread reaper = new Thread(new Runnable(){

                public void run() {
                    HMCSession.this.reapTasks();
                }
            }, "Task reaper for HMC session " + this.sessionId);
            reaper.setDaemon(true);
            reaper.start();
        }
        this.fireTaskEndedEvent(task);
    }

    private synchronized void reapTasks() {
        while (true) {
            long now;
            long reapTime = now = System.currentTimeMillis();
            Iterator iterator = this.endedTasks.iterator();
            while (iterator.hasNext()) {
                PanelModelTaskPortal task = (PanelModelTaskPortal)iterator.next();
                reapTime = ((Date)task.getAttribute(REAP_TIME_ATTRIBUTE_IN_PORTAL)).getTime();
                if (now < reapTime) break;
                iterator.remove();
                this.removeTask(task.getTaskId());
            }
            if (this.endedTasks.size() == 0) {
                return;
            }
            try {
                this.wait(reapTime - now);
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
    }

    public synchronized Object getSessionAttribute(String name) {
        return this.sessionAttributes.get(name);
    }

    public synchronized Collection getSessionAttributeNames() {
        return new ArrayList(this.sessionAttributes.keySet());
    }

    public synchronized void setSessionAttribute(String name, Object value) {
        this.sessionAttributes.put(name, value);
    }

    public synchronized void removeSessionAttribute(String name) {
        this.sessionAttributes.remove(name);
    }

    public synchronized Object getContextAttribute(String name) {
        return this.contextAttributes.get(name);
    }

    public synchronized Collection getContextAttributeNames() {
        return new ArrayList(this.contextAttributes.keySet());
    }

    public synchronized void setContextAttribute(String name, Object value) {
        this.contextAttributes.put(name, value);
        if (this.httpSession != null) {
            this.httpSession.getServletContext().setAttribute(name, value);
        }
    }

    public synchronized void removeContextAttribute(String name) {
        this.contextAttributes.remove(name);
    }

    public void setAvailableScreenWidth(int width) {
        this.setSessionAttribute("util.availableScreenWidth", new Integer(width));
    }

    public int getAvailableScreenWidth() {
        Integer width = (Integer)this.getSessionAttribute("util.availableScreenWidth");
        if (width == null) {
            return -1;
        }
        return width;
    }

    public void setAvailableScreenHeight(int height) {
        this.setSessionAttribute("util.availableScreenHeight", new Integer(height));
    }

    public int getAvailableScreenHeight() {
        Integer height = (Integer)this.getSessionAttribute("util.availableScreenHeight");
        if (height == null) {
            return -1;
        }
        return height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        HMCSession hMCSession = this;
        synchronized (hMCSession) {
            Trace.trace(TRACE_MASKT, "Destroying HMCSession with id " + this.sessionId);
            if (this.httpSession != null) {
                this.disconnectFromWebSession();
            }
            Iterator iterator = this.taskIdToPanelPortals.values().iterator();
            while (iterator.hasNext()) {
                PanelModelTaskPortal portal = (PanelModelTaskPortal)iterator.next();
                if (portal.isTaskEnded()) continue;
                portal.getPresentationTask().forceTaskToTerminate("HMCSession is being destroyed");
            }
            this.listener.sessionIsDestroyed();
            this.fireSessionDestroyedEvent();
            HMCSession.removeDisconnectedSession(this);
            HMCSession.removeSession(this);
        }
        TaskControllerQueue.getTaskControllerQueue(this).removeTaskControllerListener(this.listener);
    }

    public synchronized boolean haveConnectivity() {
        return this.lossOfConnectivityTime != null;
    }

    public synchronized Date getLossOfConnectivityTime() {
        return this.lossOfConnectivityTime;
    }

    public synchronized void taskIsRealized(PanelModelTaskPortal task) {
        this.fireTaskRealizedEvent(task);
    }

    private synchronized void processConnectivityAcquired() {
        this.lossOfConnectivityTime = null;
        Trace.trace(TRACE_MASKT, "Gained connectivity on HMCSession with id " + this.sessionId);
        this.fireConnectivityGainedEvent();
    }

    private synchronized void processConnectivityLost(Exception e) {
        this.lossOfConnectivityTime = new Date();
        if (e == null) {
            Trace.trace(TRACE_MASKT, "Lost connectivity on HMCSession with id " + this.sessionId + " for unknown reason");
        } else if (e instanceof IOException) {
            Trace.trace(TRACE_MASKT, "Lost connectivity on HMCSession with id " + this.sessionId + " due to I/O error");
        } else {
            Trace.trace(TRACE_MASKT, "Lost connectivity on HMCSession with id " + this.sessionId + " due to exception:");
            Trace.trace(TRACE_MASKT, e);
        }
        this.fireConnectivityLostEvent();
    }

    private static void fireSessionCreatedEvent(HMCSession session) {
        if (sessionLifeListeners == null) {
            return;
        }
        Iterator iterator = new ArrayList(sessionLifeListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionLifeListener listener = (HMCSessionLifeListener)iterator.next();
            try {
                listener.sessionCreated(session);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from sessionCreated() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private static void fireSessionRemovedEvent(HMCSession session) {
        if (sessionLifeListeners == null) {
            return;
        }
        Iterator iterator = new ArrayList(sessionLifeListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionLifeListener listener = (HMCSessionLifeListener)iterator.next();
            try {
                listener.sessionRemoved(session);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from sessionRemoved() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private void fireSessionConnectedEvent() {
        Iterator iterator = new ArrayList(this.sessionListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionListener listener = (HMCSessionListener)iterator.next();
            try {
                listener.sessionConnected(this);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from sessionConnected() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private synchronized void fireSessionDisconnectedEvent() {
        Iterator iterator = new ArrayList(this.sessionListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionListener listener = (HMCSessionListener)iterator.next();
            try {
                listener.sessionDisconnected(this);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from sessionDisconnected() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private synchronized void fireSessionDestroyedEvent() {
        Iterator iterator = new ArrayList(this.sessionListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionListener listener = (HMCSessionListener)iterator.next();
            try {
                listener.sessionDestroyed(this);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from sessionDestroyed() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private void fireConnectivityLostEvent() {
        Iterator iterator = new ArrayList(this.sessionListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionListener listener = (HMCSessionListener)iterator.next();
            try {
                listener.clientConnectivityLost(this);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from clientConnectivityLost() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private void fireConnectivityGainedEvent() {
        Iterator iterator = new ArrayList(this.sessionListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionListener listener = (HMCSessionListener)iterator.next();
            try {
                listener.clientConnectivityGained(this);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from clientConnectivityGained() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private void fireTaskStartedEvent(PanelModelTaskPortal task) {
        Iterator iterator = new ArrayList(this.sessionListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionListener listener = (HMCSessionListener)iterator.next();
            try {
                listener.taskStarted(this, task);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from taskStarted() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private void fireTaskEndedEvent(PanelModelTaskPortal task) {
        Iterator iterator = new ArrayList(this.sessionListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionListener listener = (HMCSessionListener)iterator.next();
            try {
                listener.taskEnded(this, task);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from taskEnded() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private void fireTaskRealizedEvent(PanelModelTaskPortal task) {
        Iterator iterator = new ArrayList(this.sessionListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionListener listener = (HMCSessionListener)iterator.next();
            try {
                listener.taskRealized(this, task);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from taskRealized() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    static {
        allSessions = new ArrayList();
    }

    private class Listener
    implements TaskControllerListener {
        boolean sessionDestroyed;

        private Listener() {
        }

        public void taskControllerConnected(HMCSession session) {
            if (this.sessionDestroyed) {
                return;
            }
            HMCSession.this.processConnectivityAcquired();
        }

        public void taskControllerDisconnected(HMCSession session, Exception e) {
            if (this.sessionDestroyed) {
                return;
            }
            HMCSession.this.processConnectivityLost(e);
        }

        void sessionIsDestroyed() {
            this.sessionDestroyed = true;
        }
    }
}

